package ibase.marketingCampaign;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.w3c.dom.Document;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class MailingListPostSave extends ValidatorEJB {
    ActionHandlerEJB actionHandlerEJB = new ActionHandlerEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String postSave() throws RemoteException, ITMException {
		return "";
	}

	public String postSave(String domString, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
	    System.out.println("In VoucherPostSave ... ");
	    BaseLogger.log("3", null, null, "In MailingListPreSave method ");
	    Document dom = null;
	    String errorString="";
		String retString = "";

	    ConnDriver connDriver = new ConnDriver();
	    try {
	    
	    if (domString != null && domString.trim().length() != 0) {
			dom = genericUtility.parseString(domString);
		}
	    }catch (Exception e) {
			System.out.println("Exception :SfaTime :itemChanged(String,String):" + e.getMessage() + ":");
			errorString = genericUtility.createErrorString(e);
		}
	    
	    String mailListType = checkNull(genericUtility.getColumnValue("mail_list_type", dom));
	    BaseLogger.log("3", null, null, "MailingListPostSave : DOM :: [" + mailListType + "]");
	    
	    PreparedStatement selectPstmt = null;
	    PreparedStatement insertPstmt = null;
	    PreparedStatement deletePstmt = null;
	    String userId = "";
	    //Document dom = null;                
	    ResultSet rs = null;
	    boolean isError = false;
	    String selectSQLStr = ""; // this query will get name and email ID. 
	    String MailListID = "";
	    //String errorString ="";
	    
	    if ("S".equalsIgnoreCase(mailListType)) {
		    try {
		        // Delete existing records
		    	 MailListID = genericUtility.getColumnValue("mail_list_id", dom);
			        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");
		        String deleteSQL = "DELETE FROM mailing_list_det where mail_list_id = ?";
		        deletePstmt = conn.prepareStatement(deleteSQL);
		        deletePstmt.setString(1, MailListID);
		        int rowsDeleted = deletePstmt.executeUpdate();
		        BaseLogger.log("3", null, null, "MailingListPostSave : Deleted rows count :: [" + rowsDeleted + "]");
		        conn.commit();

		        E12GenericUtility genericUtility = new E12GenericUtility();
		        dom = genericUtility.parseString(domString);
		        BaseLogger.log("3", null, null, "MailingListPostSave : DOM :: [" + dom + "]");
		        selectSQLStr = genericUtility.getColumnValue("sql_str", dom);
		        BaseLogger.log("3", null, null, "MailingListPostSave : sql value :: [" + selectSQLStr + "]");
		        MailListID = genericUtility.getColumnValue("mail_list_id", dom);
		        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");

		        try {
		        selectPstmt = conn.prepareStatement(selectSQLStr);
		        rs = selectPstmt.executeQuery();
		        }catch(Exception e) {
		        	BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block of select query for S: [" + E12GenericUtility.getStackTrace(e) + "]");
			        retString = itmDBAccessEJB.getErrorString("", "VTSQLSELE", "", "", conn);
					return retString;
		        }
		        
		        
		        int rowCount = 0;
		        int lineNo = 1;
		        String[] selectParts = selectSQLStr.toLowerCase().split("from")[0].replace("select", "").trim().split(",");
		        String firstColumn = selectParts[0].trim();
		        String secondColumn = selectParts.length > 1 ? selectParts[1].trim() : "";

		        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + firstColumn + "]");
		        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + secondColumn + "]");

		        insertPstmt = conn.prepareStatement("INSERT INTO mailing_list_det (MAIL_LIST_ID, LINE_NO, EMAIL_ID, NAME) VALUES (?, ?, ?, ?)");
		        while (rs.next()) {
		            rowCount++;
		            String name = rs.getString(firstColumn);
		            String emailId = rs.getString(secondColumn);
		            BaseLogger.log("3", null, null, "MailingListPostSave : name :: [" + name + "]");
		            BaseLogger.log("3", null, null, "MailingListPostSave : emailId :: [" + emailId + "]");

		            insertPstmt.setString(1, MailListID);
		            insertPstmt.setInt(2, lineNo);
		            insertPstmt.setString(3, emailId);
		            insertPstmt.setString(4, name);
		            insertPstmt.addBatch(); // Add to batch
		            lineNo++;

		            // Execute batch every 100 inserts (or adjust as needed)
		            if (lineNo % 100 == 0) {
		                insertPstmt.executeBatch();
		                insertPstmt.clearBatch(); // Clear the batch after execution
		            }
		        }
		        // Execute any remaining batch
		        insertPstmt.executeBatch();

		        BaseLogger.log("3", null, null, "MailingListPostSave : Total rows in result set :: [" + rowCount + "]");
		        conn.commit();
		        BaseLogger.log("3", null, null, "MailingListPostSave : All inserts completed!");

		    } catch (Exception e) {
		        BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block: " + e.getMessage());
		       // errorString = getErrorString("email_id", "SQLIM", userId);
		        isError = true;
		        retString = itmDBAccessEJB.getErrorString("", "VTSQLSELE", "", "", conn);
				return retString;

		    } finally {
		        // Closing resources properly
		        if (rs != null) try { rs.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
		        if (selectPstmt != null) try { selectPstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
		        if (insertPstmt != null) try { insertPstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
		        if (deletePstmt != null) try { deletePstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
		    }

	    }
	   
	    // -------------------------------------
	    
	    if("I".equalsIgnoreCase(mailListType)) {
	    	Connection dremioConn = null;
	    	PreparedStatement dremioPstmt = null;
	    	ResultSet DremioRs = null;
	    	userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
	    	
	    	CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
	    	try {
				setUserInfo(commonDBAccessEJB.createUserInfo(userId));
			} catch (BaseException e1) {
				e1.printStackTrace();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
	    	
	    	String transDB = getUserInfo().getTransDB();

	    	
//	    	String transDB = userInfo.getTransDB();
	    	BaseLogger.log("3", null, null, "MailingListPostSave : Deleted rows count :: [" + transDB + "]");
	    	
	    	try {
	    		
	    		dremioConn = connDriver.getConnectDB(transDB+"_IN_MEM",true);
				BaseLogger.log("3", null, null, "MailingListPostSave : Dream io connection established");
				
				try {
					MailListID = genericUtility.getColumnValue("mail_list_id", dom);
			        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");
			        // Delete existing records
			        String deleteSQL = "DELETE FROM mailing_list_det where mail_list_id = ?";
			        deletePstmt = conn.prepareStatement(deleteSQL);
			        deletePstmt.setString(1, MailListID);
			        int rowsDeleted = deletePstmt.executeUpdate();
			        
			        BaseLogger.log("3", null, null, "MailingListPostSave : Deleted rows count :: [" + rowsDeleted + "]");
			        conn.commit();

			        E12GenericUtility genericUtility = new E12GenericUtility();
			        
			        dom = genericUtility.parseString(domString);
			        BaseLogger.log("3", null, null, "MailingListPostSave : DOM :: [" + dom + "]");
			        selectSQLStr = genericUtility.getColumnValue("sql_str", dom);
			        BaseLogger.log("3", null, null, "MailingListPostSave : sql value :: [" + selectSQLStr + "]");
			        MailListID = genericUtility.getColumnValue("mail_list_id", dom);
			        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");

			        //Added changes - Move execution of query in try-catch block.
			        try {
			        	dremioPstmt = dremioConn.prepareStatement(selectSQLStr);
				        DremioRs = dremioPstmt.executeQuery();	

			        }catch(Exception e) {
			        	BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block of select query: [" + E12GenericUtility.getStackTrace(e) + "]");
					        retString = itmDBAccessEJB.getErrorString("", "VTSQLSELE", "", "", conn);
							return retString;
			        }			     
			        int rowCount = 0;
			        int lineNo = 1;
			        String[] selectParts = selectSQLStr.toLowerCase().split("from")[0].replace("select", "").trim().split(",");
			        String firstColumn = selectParts[0].trim();
			        String secondColumn = selectParts.length > 1 ? selectParts[1].trim() : "";

			        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + firstColumn + "]");
			        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + secondColumn + "]");

			        insertPstmt = conn.prepareStatement("INSERT INTO mailing_list_det (MAIL_LIST_ID, LINE_NO, EMAIL_ID, NAME) VALUES (?, ?, ?, ?)");
			       
			        while (DremioRs.next()) {
			            rowCount++;
			            String name = DremioRs.getString(firstColumn);
			            String emailId = DremioRs.getString(secondColumn);
			            BaseLogger.log("3", null, null, "MailingListPostSave : name :: [" + name + "]");
			            BaseLogger.log("3", null, null, "MailingListPostSave : emailId :: [" + emailId + "]");

			            insertPstmt.setString(1, MailListID);
			            insertPstmt.setInt(2, lineNo);
			            insertPstmt.setString(3, emailId);
			            insertPstmt.setString(4, name);
			            insertPstmt.addBatch(); // Add to batch
			            lineNo++;

			            // Execute batch every 100 inserts (or adjust as needed)
			            if (lineNo % 100 == 0) {
			                insertPstmt.executeBatch();
			                insertPstmt.clearBatch(); // Clear the batch after execution
			            }
			        }
			        // Execute any remaining batch
			        insertPstmt.executeBatch();

			        BaseLogger.log("3", null, null, "MailingListPostSave : Total rows in result set :: [" + rowCount + "]");
			        conn.commit();
			        BaseLogger.log("3", null, null, "MailingListPostSave : All inserts completed!");

			    } catch (Exception e) {
			        BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block: [" + E12GenericUtility.getStackTrace(e) + "]");
			       // errorString = getErrorString("email_id", "SQLIM", userId);
			        isError = true;
			        retString = itmDBAccessEJB.getErrorString("", "VTSQLSELE", "", "", conn);
					return retString;

			    } finally {
			        // Closing resources properly
			        if (rs != null) try { rs.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			        if (selectPstmt != null) try { selectPstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			        if (insertPstmt != null) try { insertPstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			        if (deletePstmt != null) try { deletePstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			        if (DremioRs != null) try { DremioRs.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			        if (dremioPstmt != null) try { dremioPstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
			 
			    }

				
			} catch (Exception e) {
		    	BaseLogger.log("3", null, null, "MailingListPostSave : Exception in try block for In-Memory" + e.getClass().getCanonicalName() + " || " + e.getClass().getName());
				e.printStackTrace();
				retString = itmDBAccessEJB.getErrorString("", "CONNFAIL", "", "", conn);
				return retString;
			}
	    }
	    
	   
	    
//	    try {
//	        // Delete existing records
//	        String deleteSQL = "DELETE FROM mailing_list_det";
//	        pstmt3 = conn.prepareStatement(deleteSQL);
//	        int rowsDeleted = pstmt3.executeUpdate();
//	        BaseLogger.log("3", null, null, "MailingListPostSave : Deleted rows count :: [" + rowsDeleted + "]");
//	        conn.commit();
//
//	        E12GenericUtility genericUtility = new E12GenericUtility();
//	        dom = genericUtility.parseString(domString);
//	        BaseLogger.log("3", null, null, "MailingListPostSave : DOM :: [" + dom + "]");
//	        selectSQLStr = genericUtility.getColumnValue("sql_str", dom);
//	        BaseLogger.log("3", null, null, "MailingListPostSave : sql value :: [" + selectSQLStr + "]");
//	        MailListID = genericUtility.getColumnValue("mail_list_id", dom);
//	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");
//
//	        pstmt = conn.prepareStatement(selectSQLStr);
//	        rs = pstmt.executeQuery();
//
//	        int rowCount = 0;
//	        int lineNo = 1;
//	        String[] selectParts = selectSQLStr.toLowerCase().split("from")[0].replace("select", "").trim().split(",");
//	        String firstColumn = selectParts[0].trim();
//	        String secondColumn = selectParts.length > 1 ? selectParts[1].trim() : "";
//
//	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + firstColumn + "]");
//	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + secondColumn + "]");
//
//	        pstmt2 = conn.prepareStatement("INSERT INTO mailing_list_det (MAIL_LIST_ID, LINE_NO, EMAIL_ID, NAME) VALUES (?, ?, ?, ?)");
//	        while (rs.next()) {
//	            rowCount++;
//	            String name = rs.getString(firstColumn);
//	            String emailId = rs.getString(secondColumn);
//	            BaseLogger.log("3", null, null, "MailingListPostSave : name :: [" + name + "]");
//	            BaseLogger.log("3", null, null, "MailingListPostSave : emailId :: [" + emailId + "]");
//
//	            pstmt2.setString(1, MailListID);
//	            pstmt2.setInt(2, lineNo);
//	            pstmt2.setString(3, emailId);
//	            pstmt2.setString(4, name);
//	            pstmt2.addBatch(); // Add to batch
//	            lineNo++;
//
//	            // Execute batch every 100 inserts (or adjust as needed)
//	            if (lineNo % 100 == 0) {
//	                pstmt2.executeBatch();
//	                pstmt2.clearBatch(); // Clear the batch after execution
//	            }
//	        }
//	        // Execute any remaining batch
//	        pstmt2.executeBatch();
//
//	        BaseLogger.log("3", null, null, "MailingListPostSave : Total rows in result set :: [" + rowCount + "]");
//	        conn.commit();
//	        BaseLogger.log("3", null, null, "MailingListPostSave : All inserts completed!");
//
//	    } catch (Exception e) {
//	        BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block: " + e.getMessage());
//	       // errorString = getErrorString("email_id", "SQLIM", userId);
//	        isError = true;
//
//	    } finally {
//	        // Closing resources properly
//	        if (rs != null) try { rs.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
//	        if (pstmt != null) try { pstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
//	        if (pstmt2 != null) try { pstmt2.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
//	        if (pstmt3 != null) try { pstmt3.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
//	    }

	    return "";
	}
	private String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}

}
